/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.net.URL;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;

public class OperasiMidi {
    private Sequence suara;
    private Sequencer ambilSuara;
    private String namaFile;
    private boolean looping = false;
    private int repeat = 0;

    public OperasiMidi() {
        try {
            this.ambilSuara = MidiSystem.getSequencer();
        }
        catch (MidiUnavailableException midiUnavailableException) {
            // empty catch block
        }
    }

    public OperasiMidi(String fileMidi) {
        this();
        this.load(fileMidi);
    }

    public boolean load(String fileMidi) {
        try {
            this.namaFile = fileMidi;
            this.suara = MidiSystem.getSequence(this.getURL(this.namaFile));
            this.ambilSuara.setSequence(this.suara);
            this.ambilSuara.open();
            return true;
        }
        catch (InvalidMidiDataException e) {
            return false;
        }
        catch (MidiUnavailableException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void setLooping(boolean ulang) {
        this.looping = ulang;
    }

    public void setRepeat(int ulangi) {
        this.repeat = ulangi;
    }

    public Sequence getSuara() {
        return this.suara;
    }

    public String getFilename() {
        return this.namaFile;
    }

    public boolean getLooping() {
        return this.looping;
    }

    public int getRepeat() {
        return this.repeat;
    }

    private URL getURL(String filename) {
        URL url = null;
        try {
            url = this.getClass().getResource(filename);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return url;
    }

    public boolean isLoaded() {
        return this.ambilSuara.isOpen();
    }

    public void play() {
        if (!this.ambilSuara.isOpen()) {
            return;
        }
        if (this.looping) {
            this.ambilSuara.setLoopCount(-1);
            this.ambilSuara.start();
        } else {
            this.ambilSuara.setLoopCount(this.repeat);
            this.ambilSuara.start();
        }
    }

    public void stop() {
        this.ambilSuara.stop();
    }
}

