/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public class OperasiSuara {
    private AudioInputStream suara;
    private Clip klip;
    private String namaFile = "";
    private boolean looping = false;
    private int repeat = 0;

    public OperasiSuara() {
        try {
            this.klip = AudioSystem.getClip();
        }
        catch (LineUnavailableException e) {
            System.out.println("Terjadi kesalahan pada klip suara : " + e.toString());
        }
    }

    public OperasiSuara(String filesuara) {
        this();
        this.load(filesuara);
    }

    public boolean load(String filesuara) {
        try {
            this.setFilename(filesuara);
            this.suara = AudioSystem.getAudioInputStream(this.getURL(this.namaFile));
            this.klip.open(this.suara);
            return true;
        }
        catch (IOException e) {
            return false;
        }
        catch (UnsupportedAudioFileException e) {
            return false;
        }
        catch (LineUnavailableException e) {
            return false;
        }
    }

    public void setFilename(String nama_fail) {
        this.namaFile = nama_fail;
    }

    public void setLooping(boolean ulang) {
        this.looping = ulang;
    }

    public void setRepeat(int ulangi) {
        this.repeat = ulangi;
    }

    public Clip getClip() {
        return this.klip;
    }

    public int getRepeat() {
        return this.repeat;
    }

    public boolean getLooping() {
        return this.looping;
    }

    public String getNamaFile() {
        return this.namaFile;
    }

    private URL getURL(String filename) {
        URL url = null;
        try {
            url = this.getClass().getResource(filename);
            System.out.println(url);
        }
        catch (Exception e) {
            System.out.println("error url :" + e.toString());
        }
        return url;
    }

    public boolean isLoaded() {
        return this.suara != null;
    }

    public void play() {
        if (!this.isLoaded()) {
            return;
        }
        this.klip.setFramePosition(0);
        if (this.looping) {
            this.klip.loop(-1);
        } else {
            this.klip.loop(this.repeat);
        }
    }

    public void stop() {
        this.klip.stop();
    }
}

