/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;

public class URLMidi
extends Frame {
    Sequence suara;
    Sequencer ambilSuara;

    public URL getURL(String namaFile) {
        URL url = null;
        try {
            url = this.getClass().getResource(namaFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return url;
    }

    URLMidi() {
        try {
            this.suara = MidiSystem.getSequence(this.getURL("flourish.mid"));
            this.ambilSuara = MidiSystem.getSequencer();
            this.ambilSuara.setSequence(this.suara);
            this.ambilSuara.setLoopCount(-1);
            this.ambilSuara.open();
            this.ambilSuara.start();
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (MidiUnavailableException e) {
            e.printStackTrace();
        }
        this.setTitle("Test URL MIDI");
        this.setSize(300, 200);
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }

    public void paint(Graphics g) {
        g.drawString("Resolution : " + this.suara.getResolution(), 10, 50);
        g.drawString("Tick length : " + this.suara.getTickLength(), 10, 100);
        g.drawString("Tracks: " + this.suara.getTracks().length, 10, 150);
    }

    public static void main(String[] dhafiq) {
        new URLMidi();
    }
}

