/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */



/**
 *
 * @author dhafiq
 */

import java.awt.*;
import javax.swing.JFrame;

public class ScreenManager {
    private GraphicsDevice device;
    public ScreenManager(){
        GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        device = environment.getDefaultScreenDevice();
    }

    private static final DisplayMode Mode_Pilihan[] = {
        new DisplayMode(1024, 768, 32, 0),
        new DisplayMode(1024, 768, 24, 0),
        new DisplayMode(1024, 768, 16, 0),
        new DisplayMode(800, 600, 32, 0),
        new DisplayMode(800, 600, 24, 0),
        new DisplayMode(800, 600, 16, 0),
        new DisplayMode(640, 480, 32, 0),
        new DisplayMode(640, 480, 24, 0),
        new DisplayMode(640, 480, 16, 0)
    };

    public DisplayMode setResolusiLayar(int nilai){
        if(nilai >= 9)nilai = 0;
        DisplayMode sistemMode[] = device.getDisplayModes();
        for(int j=0; j<sistemMode.length; j++){
            if(periksaDisplayMode(Mode_Pilihan[nilai], sistemMode[j])){
                return Mode_Pilihan[nilai];
            }
        }
        return null;
    }

    public DisplayMode getCurrentDisplayMode(){
        return device.getDisplayMode();
    }
    public boolean periksaDisplayMode(DisplayMode mode1, DisplayMode mode2){
        if(mode1.getWidth() != mode2.getWidth() ||
                mode1.getHeight() != mode2.getHeight()){
            return false;
        }

        if(mode1.getBitDepth() != DisplayMode.BIT_DEPTH_MULTI &&
                mode2.getBitDepth() != DisplayMode.BIT_DEPTH_MULTI &&
                mode1.getBitDepth() != mode2.getBitDepth()){
            return false;
        }
        if(mode1.getRefreshRate() != DisplayMode.REFRESH_RATE_UNKNOWN && mode2.getRefreshRate() !=
                DisplayMode.REFRESH_RATE_UNKNOWN && mode1.getRefreshRate() != mode2.getRefreshRate()){
            return false;
        }
        return true;
    }

    public void setFullScreen(DisplayMode displayMode, JFrame frame){
        if(device.isFullScreenSupported()){
            frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
            frame.setUndecorated(true);
            frame.setResizable(false);
            device.setFullScreenWindow(frame);

            if(displayMode != null && device.isDisplayChangeSupported()){
                try{
                    device.setDisplayMode(displayMode);
                }
                catch(IllegalArgumentException ex){
                }
                }
                else{
                    System.out.println("Sistem Operasi Tidak Mendukung Mode Fullscreen");
                }
        }
    }

        public void tutupScreen(){
            Window window = device.getFullScreenWindow();
            if(window != null){
                window.dispose();
            }
            device.setFullScreenWindow(null);

        }
}
