/*
 * Decompiled with CFR 0.152.
 */
package Modul_6_Dhaf;

import Modul_6_Dhaf.ImageManager;
import Modul_6_Dhaf.ImageSequenceListener;
import java.awt.image.BufferedImage;

public class ImageAnimator {
    private String imName;
    private boolean isRepeating;
    private boolean ticksIgnored;
    private ImageManager imsMgr;
    private int animPeriod;
    private long animTotalTime;
    private int showPeriod;
    private double seqDuration;
    private int numImages;
    private int imPosition;
    private ImageSequenceListener listener = null;

    public ImageAnimator(String nm, int ap, double d, boolean isr, ImageManager il) {
        this.imName = nm;
        this.animPeriod = ap;
        this.seqDuration = d;
        this.isRepeating = isr;
        this.imsMgr = il;
        this.animTotalTime = 0L;
        if (this.seqDuration < 0.5) {
            System.out.println("Warning: durasi minimal 0.5 sec.");
            this.seqDuration = 0.5;
        }
        if (!this.imsMgr.isLoaded(this.imName)) {
            System.out.println(this.imName + " Tidak diketahui oleh imageManager");
            this.numImages = 0;
            this.imPosition = -1;
            this.ticksIgnored = true;
        } else {
            this.numImages = this.imsMgr.numImages(this.imName);
            this.imPosition = 0;
            this.ticksIgnored = false;
            this.showPeriod = (int)(1000.0 * this.seqDuration / (double)this.numImages);
        }
    }

    public void updateTick() {
        if (!this.ticksIgnored) {
            this.animTotalTime = (this.animTotalTime + (long)this.animPeriod) % (long)(1000.0 * this.seqDuration);
            this.imPosition = (int)(this.animTotalTime / (long)this.showPeriod);
            if (this.imPosition == this.numImages - 1 && !this.isRepeating) {
                this.ticksIgnored = true;
                if (this.listener != null) {
                    this.listener.sequenceEnded(this.imName);
                }
            }
        }
    }

    public BufferedImage getCurrentImage() {
        if (this.numImages != 0) {
            return this.imsMgr.getImage(this.imName, this.imPosition);
        }
        return null;
    }

    public int getCurrentPosition() {
        return this.imPosition;
    }

    public void addImageSequenceListener(ImageSequenceListener l) {
        this.listener = l;
    }

    public void stop() {
        this.ticksIgnored = true;
    }

    public boolean isStopped() {
        return this.ticksIgnored;
    }

    public boolean atSequenceEnd() {
        return this.imPosition == this.numImages - 1 && !this.isRepeating;
    }

    public void stopAt(int pos) {
        this.imPosition = pos;
        this.ticksIgnored = true;
    }

    public void restartAt(int imPosn) {
        if (this.numImages != 0) {
            if (imPosn < 0 || imPosn > this.numImages - 1) {
                System.out.println("Posisi restart salah, Mulai dari 0");
                imPosn = 0;
            }
            this.imPosition = imPosn;
            this.animTotalTime = (long)this.imPosition * (long)this.showPeriod;
            this.ticksIgnored = false;
        }
    }

    public void resume() {
        if (this.numImages != 0) {
            this.ticksIgnored = false;
        }
    }
}

