/*
 * Decompiled with CFR 0.152.
 */
package Modul_6_Dhaf;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.imageio.ImageIO;

public class ImageManager {
    private static final String IMAGE_DIR = "images/";
    private HashMap imagesMap;
    private String path;
    private GraphicsConfiguration gc;

    public ImageManager() {
        this.initManager();
    }

    public ImageManager(String imPath) {
        this.initManager();
        this.path = imPath;
    }

    private void initManager() {
        this.imagesMap = new HashMap();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.gc = ge.getDefaultScreenDevice().getDefaultConfiguration();
        this.path = IMAGE_DIR;
    }

    public boolean loadSingleImage(String fnm) {
        String name = this.getPrefix(fnm);
        if (this.imagesMap.containsKey(name)) {
            System.out.println("Error: " + name + "sudah digunakan");
            return false;
        }
        BufferedImage bi = this.loadImage(fnm);
        if (bi != null) {
            ArrayList<BufferedImage> imsList = new ArrayList<BufferedImage>();
            imsList.add(bi);
            this.imagesMap.put(name, imsList);
            System.out.println(" disimpan " + name + "/" + fnm);
            return true;
        }
        return false;
    }

    public int loadNumImages(String fnm, int number) {
        String prefix = this.getPrefix(fnm);
        String postfix = this.getPosfix(fnm);
        ArrayList<BufferedImage> imsList = new ArrayList<BufferedImage>();
        int loadCount = 0;
        if (this.imagesMap.containsKey(prefix)) {
            System.out.println("Error: " + prefix + "sudah digunakan");
            return 0;
        }
        if (number <= 0) {
            System.out.println("Error: Number <= 0: " + number);
            String imFnm = prefix + postfix;
            BufferedImage bi = this.loadImage(imFnm);
            if (bi != null) {
                ++loadCount;
                imsList.add(bi);
                System.out.println(" disimpan " + prefix + "/" + imFnm);
            }
        } else {
            System.out.print(" Menambahkan " + prefix + "/" + prefix + "*" + postfix + "... ");
            for (int i = 0; i < number; ++i) {
                String imFnm = prefix + i + postfix;
                BufferedImage bi = this.loadImage(imFnm);
                if (bi == null) continue;
                ++loadCount;
                imsList.add(bi);
                System.out.print(i + " ");
            }
            System.out.println();
        }
        if (loadCount == 0) {
            System.out.println("Tidak ada image dengan prefix  " + prefix);
        } else {
            this.imagesMap.put(prefix, imsList);
        }
        return loadCount;
    }

    private String getPrefix(String fnm) {
        int posn = fnm.lastIndexOf(".");
        if (posn == -1) {
            System.out.println("Prefix tidak ditemukan untuk nama file: " + fnm);
            return fnm;
        }
        return fnm.substring(0, posn);
    }

    private String getPosfix(String fnm) {
        int posn = fnm.lastIndexOf(".");
        if (posn == -1) {
            System.out.println("Posfix tidak ditemukan untuk nama file: " + fnm);
            return fnm;
        }
        return fnm.substring(posn);
    }

    public int loadStripImages(String fnm, int column, int row) {
        String name = this.getPrefix(fnm);
        if (this.imagesMap.containsKey(name)) {
            System.out.println("Error: " + name + " sudah digunakan");
            return 0;
        }
        BufferedImage[] strip = this.loadStripImageArray(fnm, column, row);
        if (strip == null) {
            return 0;
        }
        ArrayList<BufferedImage> imsList = new ArrayList<BufferedImage>();
        int loadCount = 0;
        System.out.print(" menambahkan " + name + "/" + fnm + "... ");
        for (int i = 0; i < strip.length; ++i) {
            ++loadCount;
            imsList.add(strip[i]);
            System.out.print(i + " ");
        }
        System.out.println();
        if (loadCount == 0) {
            System.out.println("Tidak ada image dengan prefix  " + name);
        } else {
            this.imagesMap.put(name, imsList);
        }
        return loadCount;
    }

    private BufferedImage[] loadStripImageArray(String fnm, int column, int row) {
        if (column <= 0) {
            System.out.println("column <= 0; returning null");
            return null;
        }
        BufferedImage stripIm = this.loadImage(fnm);
        if (stripIm == null) {
            System.out.println("Return null");
            return null;
        }
        int imWidth = stripIm.getWidth() / column;
        int imHeight = stripIm.getHeight() / row;
        int transparency = stripIm.getColorModel().getTransparency();
        BufferedImage[] strip = new BufferedImage[column * row];
        for (int i = 0; i < row; ++i) {
            for (int j = i * column; j < (i + 1) * column; ++j) {
                int fx = j % column * imWidth;
                int fy = i * imHeight;
                strip[j] = this.gc.createCompatibleImage(imWidth, imHeight, transparency);
                Graphics2D stripGC = strip[j].createGraphics();
                stripGC.setComposite(AlphaComposite.Src);
                stripGC.drawImage(stripIm, 0, 0, imWidth, imHeight, fx, fy, fx + imWidth, fy + imHeight, null);
                stripGC.dispose();
            }
        }
        return strip;
    }

    public BufferedImage getImage(String name) {
        ArrayList imsList = (ArrayList)this.imagesMap.get(name);
        if (imsList == null) {
            System.out.println("Tidak ada image dengan nama " + name);
            return null;
        }
        return (BufferedImage)imsList.get(0);
    }

    public BufferedImage getImage(String name, int posn) {
        ArrayList imsList = (ArrayList)this.imagesMap.get(name);
        if (imsList == null) {
            System.out.println("Tidak ada image dengan nama " + name);
            return null;
        }
        int size = imsList.size();
        if (posn < 0) {
            return (BufferedImage)imsList.get(0);
        }
        if (posn >= size) {
            int newPosn = posn % size;
            return (BufferedImage)imsList.get(newPosn);
        }
        return (BufferedImage)imsList.get(posn);
    }

    public ArrayList getImages(String name) {
        ArrayList imsList = (ArrayList)this.imagesMap.get(name);
        if (imsList == null) {
            System.out.println("Tidak ada image dengan nama " + name);
            return null;
        }
        return imsList;
    }

    public boolean isLoaded(String name) {
        ArrayList imsList = (ArrayList)this.imagesMap.get(name);
        return imsList != null;
    }

    public int numImages(String name) {
        ArrayList imsList = (ArrayList)this.imagesMap.get(name);
        if (imsList == null) {
            System.out.println("Tidak ada image dengan nama " + name);
            return 0;
        }
        return imsList.size();
    }

    public void setPath(String path) {
        this.path = path;
    }

    private BufferedImage loadImage(String fnm) {
        try {
            BufferedImage im = this.path.equals(IMAGE_DIR) ? ImageIO.read(this.getClass().getResource(this.path + fnm)) : ImageIO.read(new File(this.path + "/" + fnm));
            int transparency = im.getColorModel().getTransparency();
            BufferedImage copy = this.gc.createCompatibleImage(im.getWidth(), im.getHeight(), transparency);
            Graphics2D g2d = copy.createGraphics();
            g2d.drawImage((Image)im, 0, 0, null);
            g2d.dispose();
            return copy;
        }
        catch (IOException e) {
            System.out.println("Gagal memuat " + this.path + "/" + fnm + ":\n" + e);
            return null;
        }
    }
}

