/*
 * Decompiled with CFR 0.152.
 */
package Modul_6_Dhaf;

import Modul_6_Dhaf.ImageAnimator;
import Modul_6_Dhaf.ImageManager;
import Modul_6_Dhaf.ImageSequenceListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ImagesTest2
extends JPanel
implements ImageSequenceListener,
Runnable {
    private static final int PERIOD = 50;
    private static final int PWIDTH = 600;
    private static final int PHEIGHT = 400;
    private ImageManager imsLoader;
    private ImageAnimator mihPlayer;
    private ImageAnimator catsPlayer;
    private ImageAnimator kaboomPlayer;
    private ImageAnimator jeballPlayer;
    private ImageAnimator numbersPlayer;
    Thread t;

    public ImagesTest2() {
        this.setBackground(Color.white);
        this.setPreferredSize(new Dimension(600, 400));
        this.imsLoader = new ImageManager();
        this.imsLoader.setPath("jeni6/images");
        try {
            this.imsLoader.loadNumImages("25_04_.gif", 15);
            this.imsLoader.loadNumImages("numbers.gif", 6);
            this.imsLoader.loadStripImages("boom.png", 5, 1);
            this.imsLoader.loadStripImages("ball.png", 8, 4);
            this.imsLoader.loadStripImages("cats.gif", 6, 1);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        this.initImages();
        this.t = new Thread(this);
    }

    private void initImages() {
        this.mihPlayer = new ImageAnimator("25_04_", 50, 1.5, true, this.imsLoader);
        this.numbersPlayer = new ImageAnimator("numbers", 50, 6.0, false, this.imsLoader);
        this.numbersPlayer.addImageSequenceListener(this);
        this.catsPlayer = new ImageAnimator("cats", 50, 0.5, true, this.imsLoader);
        this.kaboomPlayer = new ImageAnimator("boom", 50, 1.0, true, this.imsLoader);
        this.jeballPlayer = new ImageAnimator("ball", 50, 1.0, true, this.imsLoader);
    }

    public void sequenceEnded(String imageName) {
        System.out.println(imageName + " sequence has ended");
    }

    private void imagesUpdate() {
        this.mihPlayer.updateTick();
        this.numbersPlayer.updateTick();
        this.catsPlayer.updateTick();
        this.kaboomPlayer.updateTick();
        this.jeballPlayer.updateTick();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(Color.blue);
        g2d.fillRect(0, 0, 600, 400);
        this.drawImage(g2d, this.mihPlayer.getCurrentImage(), 10, 10);
        this.drawImage(g2d, this.numbersPlayer.getCurrentImage(), 200, 10);
        this.drawImage(g2d, this.catsPlayer.getCurrentImage(), 10, 235);
        this.drawImage(g2d, this.kaboomPlayer.getCurrentImage(), 400, 10);
        this.drawImage(g2d, this.jeballPlayer.getCurrentImage(), 350, 270);
    }

    private void drawImage(Graphics2D g2d, BufferedImage im, int x, int y) {
        g2d.drawImage((Image)im, x, y, this);
    }

    public static void main(String[] args) {
        ImagesTest2 ttPanel = new ImagesTest2();
        ttPanel.start();
        JFrame app = new JFrame("Image Manager Test");
        app.getContentPane().add((Component)ttPanel, "Center");
        app.setDefaultCloseOperation(3);
        app.pack();
        app.setResizable(false);
        app.setVisible(true);
    }

    public void start() {
        this.t.start();
    }

    public void run() {
        while (Thread.currentThread() == this.t) {
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.imagesUpdate();
            this.repaint();
        }
    }
}

