/*
 * Decompiled with CFR 0.152.
 */
package Modul_7_Dhaf;

import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public class ImageEfek {
    AffineTransform at;
    private GraphicsConfiguration gc;

    public ImageEfek() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.gc = ge.getDefaultScreenDevice().getDefaultConfiguration();
    }

    public BufferedImage getRotatedImage(BufferedImage src, int angle) {
        int transparency = src.getColorModel().getTransparency();
        int center = Math.max(src.getWidth(), src.getHeight()) / 2;
        BufferedImage dest = this.gc.createCompatibleImage(Math.max(src.getWidth(), src.getHeight()), Math.max(src.getWidth(), src.getHeight()), transparency);
        Graphics2D g2d = dest.createGraphics();
        AffineTransform origAT = g2d.getTransform();
        AffineTransform rot = new AffineTransform();
        rot.rotate(Math.toRadians(angle), center, center);
        g2d.transform(rot);
        g2d.drawImage((Image)src, 0, 0, null);
        g2d.setTransform(origAT);
        g2d.dispose();
        return dest;
    }

    public BufferedImage getScaledImage(BufferedImage src, double sx, double sy) {
        int transparency = src.getColorModel().getTransparency();
        BufferedImage dest = this.gc.createCompatibleImage((int)Math.ceil((double)src.getWidth() * sx), (int)Math.ceil((double)src.getHeight() * sy), transparency);
        Graphics2D g2d = dest.createGraphics();
        AffineTransform origAT = g2d.getTransform();
        AffineTransform scale = new AffineTransform();
        scale.scale(sx, sy);
        g2d.transform(scale);
        g2d.drawImage((Image)src, 0, 0, null);
        g2d.setTransform(origAT);
        g2d.dispose();
        return dest;
    }

    public BufferedImage getTranslatedImage(BufferedImage src, int tx, int ty) {
        int transparency = src.getColorModel().getTransparency();
        BufferedImage dest = this.gc.createCompatibleImage(src.getWidth(), src.getHeight(), transparency);
        Graphics2D g2d = dest.createGraphics();
        AffineTransform origAT = g2d.getTransform();
        AffineTransform trans = new AffineTransform();
        trans.translate(tx, ty);
        g2d.transform(trans);
        g2d.drawImage((Image)src, 0, 0, null);
        g2d.setTransform(origAT);
        g2d.dispose();
        return dest;
    }
}

