/*
 * Decompiled with CFR 0.152.
 */
package Modul_7_Dhaf;

import Modul_6_Dhaf.ImageManager;
import Modul_7_Dhaf.ImageEfek;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class TestTransformasi
extends JPanel
implements Runnable {
    private Thread th;
    private boolean running;
    private BufferedImage bufImg;
    private Graphics2D g2d;
    private BufferedImage oriImg;
    private BufferedImage transformImg;
    private ImageManager imsMgr;
    private ImageEfek imgEfek;
    private double scalex = 0.0;
    private double scaley = 0.0;
    private int rotAngle;

    TestTransformasi() {
        this.setPreferredSize(new Dimension(600, 400));
        this.imgEfek = new ImageEfek();
        this.imsMgr = new ImageManager();
        this.imsMgr.setPath("jeniTransform/images");
        this.imsMgr.loadSingleImage("maninhat.gif");
        this.oriImg = this.imsMgr.getImage("maninhat");
    }

    public void start() {
        this.th = new Thread(this);
        this.th.start();
        this.running = true;
    }

    public void stop() {
        this.running = false;
    }

    public void run() {
        while (this.running) {
            try {
                Thread.sleep(20L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.update();
            this.render();
            this.repaint();
        }
    }

    public void paintComponent(Graphics g) {
        g.drawImage(this.bufImg, 0, 0, null);
    }

    public void render() {
        if (this.bufImg == null) {
            this.bufImg = (BufferedImage)this.createImage(600, 400);
            if (this.bufImg == null) {
                System.out.println("dbImage null");
                return;
            }
            this.g2d = (Graphics2D)this.bufImg.getGraphics();
        }
        this.g2d.setColor(Color.gray);
        this.g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.transformImg = this.imgEfek.getScaledImage(this.oriImg, this.scalex, this.scaley);
        this.transformImg = this.imgEfek.getRotatedImage(this.transformImg, this.rotAngle);
        this.g2d.drawImage((Image)this.transformImg, 300 - this.transformImg.getWidth() / 2, 200 - this.transformImg.getHeight() / 2, null);
    }

    public void update() {
        if (this.scalex <= 2.0) {
            this.scalex += 0.01;
            this.scaley += 0.01;
        }
        this.rotAngle += 2;
    }

    public static void main(String[] args) {
        TestTransformasi ttPanel = new TestTransformasi();
        ttPanel.start();
        JFrame app = new JFrame("Transformasi");
        app.getContentPane().add((Component)ttPanel, "Center");
        app.setDefaultCloseOperation(3);
        app.pack();
        app.setResizable(false);
        app.setVisible(true);
    }
}

