/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package Modul_7_Dhaf;

/**
 *
 * @author user
 */
import java.awt.*;
import java.awt.geom.*;
import java.awt.image.*;

public class ImageEfek {
      AffineTransform at;
      private GraphicsConfiguration gc;
      
      public ImageEfek(){
             GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
             gc = ge.getDefaultScreenDevice().getDefaultConfiguration();
      }
      
      public BufferedImage getRotatedImage(BufferedImage src, int angle){
          int transparency = src.getColorModel().getTransparency();
          int center= Math.max(src.getWidth(),src.getHeight())/2;
          BufferedImage dest = gc.createCompatibleImage( Math.max(src.getWidth(),src.getHeight()),Math.max(src.getWidth(),src.getHeight()), transparency );
          Graphics2D g2d = dest.createGraphics();
          AffineTransform origAT = g2d.getTransform();
          AffineTransform rot = new AffineTransform();
          rot.rotate( Math.toRadians(angle), center, center);
          g2d.transform(rot);
          g2d.drawImage(src, 0, 0, null);
          g2d.setTransform(origAT);
          g2d.dispose();
          return dest;
      }
      
      public BufferedImage getScaledImage(BufferedImage src, double sx, double sy){
            int transparency = src.getColorModel().getTransparency();
            BufferedImage dest = gc.createCompatibleImage((int)Math.ceil(src.getWidth()*sx),
                                 (int)Math.ceil(src.getHeight()*sy), transparency );
            Graphics2D g2d = dest.createGraphics();
            AffineTransform origAT = g2d.getTransform();
            AffineTransform scale = new AffineTransform();
            
         //   scale.setTransform(identity);
            scale.scale(sx, sy);
            g2d.transform(scale);
            g2d.drawImage(src, 0, 0, null);
            
        // g2d.drawImage(src, scale, null);
            g2d.setTransform(origAT);
            g2d.dispose();
            return dest;
      }
      public BufferedImage getTranslatedImage(BufferedImage src, int tx,int ty){
            int transparency = src.getColorModel().getTransparency();
            BufferedImage dest = gc.createCompatibleImage(src.getWidth(), src.getHeight(),transparency );
            Graphics2D g2d = dest.createGraphics();
            AffineTransform origAT = g2d.getTransform();
            AffineTransform trans = new AffineTransform();
            trans.translate(tx, ty);
            g2d.transform(trans);
            g2d.drawImage(src, 0, 0, null);
            g2d.setTransform(origAT);
            g2d.dispose();
            return dest;
      }
}

