/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package Modul_7_Dhaf;

/**
 *
 * @author user
 */
import java.awt.*;
import java.awt.image.*;
import javax.swing.*;
import Modul_6_Dhaf.*;

public class TestTransformasi extends JPanel implements Runnable{
    
    private Thread th;
    private boolean running;
    private BufferedImage bufImg;
    private Graphics2D g2d;
    
    private BufferedImage oriImg;
    private BufferedImage transformImg;
    
    private ImageManager imsMgr;
    private ImageEfek imgEfek;
    
    private double scalex=0, scaley=0;
    private int rotAngle;
    
    TestTransformasi(){
        setPreferredSize (new Dimension(600, 400));
        imgEfek = new ImageEfek();
        imsMgr = new ImageManager();
        imsMgr.setPath("jeniTransform/images");
        imsMgr.loadSingleImage("maninhat.gif");
        oriImg = imsMgr.getImage("maninhat");
    }
    
    public void start(){
        th = new Thread(this);
        th.start();
        running = true;
    }
    
    public void stop(){
        running=false;
    }
    
    public void run(){
        while(running){
            try{
                Thread.sleep(20);
            }catch(Exception e){}
            
            update();
            render();
            repaint();
        }
    }
    
    public void paintComponent (Graphics g){
        g.drawImage(bufImg, 0, 0, null);
    }
    
    public void render(){
        if(bufImg == null){
            bufImg = (BufferedImage) createImage(600, 400);
            if(bufImg == null){
                System.out.println("dbImage null");
                return;
            }else
                g2d = (Graphics2D) bufImg.getGraphics();
        }
        
        g2d.setColor(Color.gray);
        g2d.fillRect(0, 0, getWidth(), getHeight());
        
        transformImg = imgEfek.getScaledImage(oriImg, scalex, scaley);
        transformImg = imgEfek.getRotatedImage(transformImg, rotAngle);
        g2d.drawImage(transformImg, (600/2)-(transformImg.getWidth()/2), (400/2)-(transformImg.getHeight()/2), null);
    }

    public void update(){
        if(scalex<=2){
            scalex+=0.01;
            scaley+=0.01;
        }
        
        //if(rotAngle<360)
            rotAngle+=2;
    }
    
    public static void main (String [] args){
        TestTransformasi ttPanel = new TestTransformasi();
        ttPanel.start();
        
        JFrame app = new JFrame("Transformasi");
        app.getContentPane().add(ttPanel, BorderLayout.CENTER);
        app.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        app.pack();
        app.setResizable(false);
        app.setVisible(true);
    }
}
