/*
 * Decompiled with CFR 0.152.
 */
package Modul_8_Dhaf;

import Modul_6_Dhaf.ImageManager;
import Modul_8_Dhaf.BulletSprite;
import Modul_8_Dhaf.HeliSprite;
import Modul_8_Dhaf.Sprite;
import java.util.ArrayList;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnemySprite
extends HeliSprite {
    private long nextMoveTime;
    private long nextStateTime;
    private long fireSpaceTime;
    private Random rand = new Random();
    private ArrayList enemyList;
    private ArrayList<BulletSprite> bulletList;
    private Sprite target;

    public EnemySprite(int x, int y, ImageManager imsLd, String name, ArrayList enemyList, ArrayList<BulletSprite> bulletSprite) {
        super(x, y, imsLd, name);
        this.nextMoveTime = System.currentTimeMillis() + 1000L + (long)this.rand.nextInt(2000);
        this.nextStateTime = System.currentTimeMillis() + 1000L + (long)this.rand.nextInt(2000);
        this.enemyList = enemyList;
        this.bulletList = bulletSprite;
    }

    public void setTarget(Sprite target) {
        this.target = target;
    }

    public void updateMovement() {
        if (this.getState() != HeliSprite.STATE_EXPLODING && System.currentTimeMillis() >= this.nextMoveTime) {
            this.dx = this.rand.nextInt(3) - this.rand.nextInt(3);
            this.dy = 1 + this.rand.nextInt(2);
            this.nextMoveTime = System.currentTimeMillis() + 1000L + (long)this.rand.nextInt();
        }
    }

    public void updateState() {
        if (System.currentTimeMillis() > this.nextStateTime && this.pState != HeliSprite.STATE_EXPLODING) {
            if (this.pState != HeliSprite.STATE_FIRING) {
                if (this.target.getYPosn() > this.getYPosn() + this.getHeight() && this.target.getXPosn() >= this.getXPosn() - 100 && this.target.getXPosn() + this.target.getWidth() <= this.getXPosn() + this.getWidth() + 100) {
                    this.pState = HeliSprite.STATE_FIRING;
                    this.fire();
                }
                this.nextStateTime = System.currentTimeMillis() + 100L + (long)this.rand.nextInt(300);
                this.fireSpaceTime = 0L;
            } else {
                this.nextStateTime = System.currentTimeMillis() + 1000L + (long)this.rand.nextInt(3000);
                this.pState = HeliSprite.STATE_NORMAL;
                this.normal();
            }
        }
        if (this.pState == HeliSprite.STATE_FIRING) {
            this.updateFire();
        }
    }

    public void updateFire() {
        if (System.currentTimeMillis() >= this.fireSpaceTime) {
            int x = this.getXPosn();
            int y = this.getYPosn();
            BulletSprite leftBullet = new BulletSprite(x + 30, y + 90, this.imsMgr, "greenPlasma", this.bulletList);
            leftBullet.setStep(0, 5);
            BulletSprite rightBullet = new BulletSprite(x + 57, y + 90, this.imsMgr, "greenPlasma", this.bulletList);
            rightBullet.setStep(0, 5);
            this.bulletList.add(leftBullet);
            this.bulletList.add(rightBullet);
            this.fireSpaceTime = System.currentTimeMillis() + 150L;
        }
    }

    @Override
    public void sequenceEnded(String imageName) {
        this.enemyList.remove(this);
    }
}

