/*
 * Decompiled with CFR 0.152.
 */
package Modul_8_Dhaf;

import Modul_6_Dhaf.ImageManager;
import Modul_8_Dhaf.Sprite;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeliSprite
extends Sprite {
    public static int STATE_AWAKENING = 0;
    public static int STATE_FIRING = 1;
    public static int STATE_NORMAL = 2;
    public static int STATE_EXPLODING = 3;
    protected int pState;
    protected String oriImageName;
    ArrayList<Rectangle> boundingBoxs = new ArrayList();
    ArrayList<Point> originalPoints = new ArrayList();

    public HeliSprite(int x, int y, ImageManager imsLd, String name) {
        super(x, y, imsLd, name);
        this.oriImageName = name;
    }

    public void clearBondingBoxs() {
        this.boundingBoxs.clear();
        this.originalPoints.clear();
    }

    public void addBoundingBox(Rectangle rect) {
        this.boundingBoxs.add(rect);
        this.originalPoints.add(rect.getLocation());
    }

    public ArrayList<Rectangle> getBoundingBoxs() {
        this.repositionBoundingBoxs();
        return this.boundingBoxs;
    }

    public void repositionBoundingBoxs() {
        for (int i = 0; i < this.boundingBoxs.size(); ++i) {
            this.boundingBoxs.get(i).setLocation(this.originalPoints.get((int)i).x + this.locx, this.originalPoints.get((int)i).y + this.locy);
        }
    }

    public boolean isCollidedWith(Sprite sprite) {
        if (sprite instanceof HeliSprite) {
            if (((HeliSprite)sprite).getBoundingBoxs().size() > 0) {
                return this.isCollidedWith(((HeliSprite)sprite).getBoundingBoxs());
            }
            return this.isCollidedWith(sprite.getBoundingBox());
        }
        return this.isCollidedWith(sprite.getBoundingBox());
    }

    public boolean isCollidedWith(ArrayList<Rectangle> bBox) {
        if (this.boundingBoxs.size() > 0) {
            this.repositionBoundingBoxs();
            for (int i = 0; i < this.boundingBoxs.size(); ++i) {
                for (int j = 0; j < bBox.size(); ++j) {
                    if (!this.boundingBoxs.get(i).intersects(bBox.get(i))) continue;
                    return true;
                }
            }
        } else {
            for (int i = 0; i < bBox.size(); ++i) {
                if (!this.CollissionCheck(bBox.get(i))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isCollidedWith(Rectangle box) {
        if (this.boundingBoxs.size() > 0) {
            this.repositionBoundingBoxs();
            for (int i = 0; i < this.boundingBoxs.size(); ++i) {
                if (!box.intersects(this.boundingBoxs.get(i))) continue;
                return true;
            }
        } else {
            return this.CollissionCheck(box);
        }
        return false;
    }

    public boolean CollissionCheck(Rectangle rec) {
        return this.getBoundingBox().intersects(rec);
    }

    public void fire() {
        this.setImage(this.oriImageName + "Fire");
        this.loopImage(50, 0.5, true);
    }

    public void normal() {
        this.pState = STATE_NORMAL;
        this.setImage(this.oriImageName);
        this.loopImage(50, 0.5, true);
    }

    public void explode() {
        this.pState = STATE_EXPLODING;
        this.setImage("explosion");
        this.loopImage(50, 1.0, false);
        this.clearBondingBoxs();
        this.setStep(0, 0);
    }

    @Override
    public void sequenceEnded(String imageName) {
        this.normal();
    }

    public int getState() {
        return this.pState;
    }
}

