/*
 * Decompiled with CFR 0.152.
 */
package Modul_8_Dhaf;

import Modul_6_Dhaf.ImageAnimator;
import Modul_6_Dhaf.ImageManager;
import Modul_6_Dhaf.ImageSequenceListener;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

public class Sprite
implements ImageSequenceListener {
    protected ImageManager imsMgr;
    protected String imageName;
    protected BufferedImage image;
    protected int width;
    protected int height;
    protected ImageAnimator animator;
    protected boolean isLooping;
    protected boolean isActive = true;
    protected int locx;
    protected int locy;
    protected int dx;
    protected int dy;

    public Sprite(int x, int y, ImageManager imsLd, String name) {
        this.locx = x;
        this.locy = y;
        this.dy = 0;
        this.dx = 0;
        this.imsMgr = imsLd;
        this.setImage(name);
    }

    public void setImage(String name) {
        this.imageName = name;
        this.image = this.imsMgr.getImage(this.imageName);
        if (this.image == null) {
            System.out.println("Tidak ada gambar dengan nama " + this.imageName);
        } else {
            this.width = this.image.getWidth();
            this.height = this.image.getHeight();
        }
        this.animator = null;
        this.isLooping = false;
    }

    public void loopImage(int animPeriod, double seqDuration, boolean isRepeating) {
        if (this.imsMgr.numImages(this.imageName) > 1) {
            this.animator = null;
            this.animator = new ImageAnimator(this.imageName, animPeriod, seqDuration, isRepeating, this.imsMgr);
            this.animator.addImageSequenceListener(this);
            this.isLooping = true;
        } else {
            System.out.println(this.imageName + "bukan gambar berurutan");
        }
    }

    public void stopLooping() {
        if (this.isLooping) {
            this.animator.stop();
            this.isLooping = false;
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean a) {
        this.isActive = a;
    }

    public void setPosition(int x, int y) {
        this.locx = x;
        this.locy = y;
    }

    public void translate(int xDist, int yDist) {
        this.locx += xDist;
        this.locy += yDist;
    }

    public int getXPosn() {
        return this.locx;
    }

    public int getYPosn() {
        return this.locy;
    }

    public void setStep(int dx, int dy) {
        this.dx = dx;
        this.dy = dy;
    }

    public int getXStep() {
        return this.dx;
    }

    public int getYStep() {
        return this.dy;
    }

    public Rectangle getBoundingBox() {
        return new Rectangle(this.locx, this.locy, this.width, this.height);
    }

    public void updateSprite() {
        if (this.isActive()) {
            this.locx += this.dx;
            this.locy += this.dy;
            if (this.isLooping) {
                this.animator.updateTick();
            }
        }
    }

    public void drawSprite(Graphics g) {
        if (this.isActive()) {
            if (this.isLooping) {
                this.image = this.animator.getCurrentImage();
            }
            g.drawImage(this.image, this.locx, this.locy, null);
        }
    }

    public void restartAt(int pos) {
        this.animator.restartAt(pos);
    }

    public void stopAt(int pos) {
        this.animator.stopAt(pos);
        this.isLooping = false;
    }

    public void resume() {
        this.animator.resume();
    }

    public void sequenceEnded(String imageName) {
    }
}

