/*
 * Decompiled with CFR 0.152.
 */
package Modul_8_Dhaf;

import Modul_6_Dhaf.ImageManager;
import Modul_8_Dhaf.BulletSprite;
import Modul_8_Dhaf.EnemySprite;
import Modul_8_Dhaf.HeliSprite;
import Modul_8_Dhaf.PlayerSprite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class TestSprite
extends JPanel
implements Runnable,
MouseListener,
KeyListener {
    private Thread th;
    private ImageManager imsMgr;
    private boolean showBound = false;
    private boolean showHelp = true;
    private boolean pause = true;
    private PlayerSprite player;
    private boolean fireEnable;
    private int enemyMaxSize = 5;
    private BufferedImage HelpImage;
    private String[] enemySprite = new String[]{"adHeli", "navyHeli", "stHeli", "tigerHeli", "whiteHeli"};
    private long shootSpaceTime;
    private long reSpawnTime;
    private ArrayList<EnemySprite> enemySprites;
    private ArrayList<BulletSprite> playerBullet = new ArrayList();
    private ArrayList<BulletSprite> enemyBullet = new ArrayList();
    private Random rand = new Random();
    private Graphics2D g2d;
    private BufferedImage bufImg;
    private boolean running;

    public TestSprite() {
        this.setPreferredSize(new Dimension(800, 600));
        this.imsMgr = new ImageManager();
        this.th = new Thread(this);
        this.running = true;
        this.init();
        this.HelpImage = this.imsMgr.getImage("HeliHelp");
        this.addMouseListener(this);
    }

    public void init() {
        this.imageLoad();
        this.initPlayer();
        this.initEnemy();
    }

    public void imageLoad() {
        this.imsMgr = new ImageManager();
        this.imsMgr.setPath("Jeni7/images");
        this.imsMgr.loadSingleImage("HeliWarBackground.png");
        this.imsMgr.loadStripImages("playerHeli.png", 4, 1);
        this.imsMgr.loadStripImages("playerHeliFire.png", 4, 1);
        this.imsMgr.loadStripImages("playerHeliAwake.png", 4, 4);
        this.imsMgr.loadStripImages("adHeli.png", 4, 1);
        this.imsMgr.loadStripImages("navyHeli.png", 4, 1);
        this.imsMgr.loadStripImages("stHeli.png", 4, 1);
        this.imsMgr.loadStripImages("tigerHeli.png", 4, 1);
        this.imsMgr.loadStripImages("whiteHeli.png", 4, 1);
        this.imsMgr.loadStripImages("adHeliFire.png", 4, 1);
        this.imsMgr.loadStripImages("navyHeliFire.png", 4, 1);
        this.imsMgr.loadStripImages("stHeliFire.png", 4, 1);
        this.imsMgr.loadStripImages("tigerHeliFire.png", 4, 1);
        this.imsMgr.loadStripImages("whiteHeliFire.png", 4, 1);
        this.imsMgr.loadSingleImage("redPlasma.png");
        this.imsMgr.loadSingleImage("greenPlasma.png");
        this.imsMgr.loadSingleImage("HeliHelp.png");
        this.imsMgr.loadStripImages("explosion.png", 4, 4);
        this.imsMgr.loadStripImages("explosion2.png", 4, 2);
        this.imsMgr.loadStripImages("explosion3.png", 5, 2);
    }

    public void initPlayer() {
        this.player = new PlayerSprite(200, 400, this.imsMgr, "playerHeli");
        this.player.loopImage(50, 0.5, true);
        this.player.setStep(0, 0);
        this.player.addBoundingBox(new Rectangle(40, 0, 15, 95));
        this.player.addBoundingBox(new Rectangle(30, 5, 35, 35));
        this.player.repositionBoundingBoxs();
    }

    public void initEnemy() {
        this.enemySprites = new ArrayList();
        for (int i = 0; i < this.enemyMaxSize; ++i) {
            EnemySprite em = new EnemySprite(this.rand.nextInt(700), -this.rand.nextInt(100), this.imsMgr, this.enemySprite[this.rand.nextInt(5)], this.enemySprites, this.enemyBullet);
            em.loopImage(50, 0.5, true);
            em.setStep(this.rand.nextInt(2) - this.rand.nextInt(2), 1 + this.rand.nextInt(2));
            em.addBoundingBox(new Rectangle(40, 0, 15, 95));
            em.addBoundingBox(new Rectangle(30, 50, 35, 35));
            em.repositionBoundingBoxs();
            em.setTarget(this.player);
            this.enemySprites.add(em);
        }
    }

    public void start() {
        this.th.start();
    }

    public void stop() {
        this.running = false;
    }

    public void run() {
        while (this.running) {
            try {
                Thread.sleep(20L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.update();
            this.render();
            this.repaint();
        }
    }

    public void update() {
        if (!this.pause) {
            BulletSprite bp;
            int i;
            this.collsionCheck();
            this.player.updateSprite();
            if (this.fireEnable) {
                this.fire();
            }
            for (i = 0; i < this.enemySprites.size(); ++i) {
                EnemySprite es = this.enemySprites.get(i);
                if (i == this.enemySprites.size()) break;
                es.updateSprite();
                es.updateMovement();
                es.updateState();
                if (es.getXPosn() <= 0 || es.getXPosn() + es.getWidth() >= 800) {
                    es.setStep(-es.getXStep(), es.getYStep());
                }
                if (es.getYPosn() < 800) continue;
                es.setPosition(es.getXPosn(), -100);
            }
            for (i = 0; i < this.enemyBullet.size(); ++i) {
                bp = this.enemyBullet.get(i);
                bp.updateSprite();
                if (bp.getYPosn() > 0 && bp.getYPosn() < 600) continue;
                this.enemyBullet.remove(bp);
            }
            for (i = 0; i < this.playerBullet.size(); ++i) {
                bp = this.playerBullet.get(i);
                bp.updateSprite();
                if (bp.getYPosn() > 0 && bp.getYPosn() < 600) continue;
                this.playerBullet.remove(bp);
            }
            if (System.currentTimeMillis() >= this.reSpawnTime) {
                this.reSpawnEnemy();
            }
        }
    }

    public void collsionCheck() {
        int j;
        EnemySprite em;
        int i;
        for (i = 0; i < this.enemySprites.size(); ++i) {
            em = this.enemySprites.get(i);
            if (!this.player.isCollidedWith(em) || this.player.getState() == HeliSprite.STATE_EXPLODING || em.getState() == HeliSprite.STATE_EXPLODING) continue;
            this.player.explode();
            this.fireEnable = false;
            em.explode();
        }
        for (i = 0; i < this.enemyBullet.size(); ++i) {
            BulletSprite bp = this.enemyBullet.get(i);
            if (bp.getState() != BulletSprite.STATE_NORMAL || !this.player.isCollidedWith(bp)) continue;
            bp.explode();
        }
        for (i = 0; i < this.enemySprites.size(); ++i) {
            em = this.enemySprites.get(i);
            for (j = 0; j < this.playerBullet.size(); ++j) {
                BulletSprite bp = this.playerBullet.get(j);
                if (bp.getState() != BulletSprite.STATE_NORMAL || em.getState() == HeliSprite.STATE_EXPLODING || !em.isCollidedWith(bp)) continue;
                bp.explode();
                em.explode();
            }
        }
        for (i = 0; i < this.playerBullet.size(); ++i) {
            BulletSprite bpp = this.playerBullet.get(i);
            for (j = 0; j < this.enemyBullet.size(); ++j) {
                BulletSprite bpe = this.enemyBullet.get(j);
                if (bpe.getState() != BulletSprite.STATE_NORMAL || bpp.getState() != BulletSprite.STATE_NORMAL || !bpp.getBoundingBox().intersects(bpe.getBoundingBox())) continue;
                bpp.explode();
                bpe.explode();
            }
        }
    }

    public void fire() {
        if (System.currentTimeMillis() >= this.shootSpaceTime) {
            BulletSprite leftBullet = new BulletSprite(this.player.getXPosn() + 30, this.player.getYPosn(), this.imsMgr, "redPlasma", this.playerBullet);
            leftBullet.setStep(0, -6);
            leftBullet.setOwner(this.player);
            BulletSprite rightBullet = new BulletSprite(this.player.getXPosn() + 57, this.player.getYPosn(), this.imsMgr, "redPlasma", this.playerBullet);
            rightBullet.setStep(0, -6);
            rightBullet.setOwner(this.player);
            this.playerBullet.add(rightBullet);
            this.playerBullet.add(leftBullet);
            this.shootSpaceTime = System.currentTimeMillis() + 100L;
        }
    }

    public void reSpawnEnemy() {
        for (int i = 0; i < this.enemyMaxSize - this.enemySprites.size(); ++i) {
            EnemySprite es = new EnemySprite(this.rand.nextInt(700), -this.rand.nextInt(100), this.imsMgr, this.enemySprite[this.rand.nextInt(5)], this.enemySprites, this.enemyBullet);
            es.loopImage(50, 0.5, true);
            es.setStep(this.rand.nextInt(2) - this.rand.nextInt(2), 1 + this.rand.nextInt(2));
            es.addBoundingBox(new Rectangle(40, 0, 15, 95));
            es.addBoundingBox(new Rectangle(30, 50, 35, 35));
            es.repositionBoundingBoxs();
            es.setTarget(this.player);
            this.enemySprites.add(es);
            this.reSpawnTime = System.currentTimeMillis() + (long)this.rand.nextInt(2000);
        }
    }

    public void render() {
        int i;
        if (this.bufImg == null) {
            this.bufImg = (BufferedImage)this.createImage(800, 600);
            if (this.bufImg == null) {
                System.out.println("dbImage is null");
                return;
            }
            this.g2d = (Graphics2D)this.bufImg.getGraphics();
        }
        this.g2d.setColor(Color.black);
        this.g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.g2d.drawImage((Image)this.imsMgr.getImage("HeliWarBackground"), 0, 0, null);
        this.player.drawSprite(this.g2d);
        for (i = 0; i < this.enemySprites.size(); ++i) {
            this.enemySprites.get(i).drawSprite(this.g2d);
        }
        for (i = 0; i < this.playerBullet.size(); ++i) {
            this.playerBullet.get(i).drawSprite(this.g2d);
        }
        for (i = 0; i < this.enemyBullet.size(); ++i) {
            this.enemyBullet.get(i).drawSprite(this.g2d);
        }
        if (this.showBound) {
            this.drawSpriteBound(this.g2d);
        }
        if (this.showHelp) {
            this.g2d.drawImage((Image)this.HelpImage, this.getWidth() / 2 - this.HelpImage.getWidth() / 2, this.getHeight() / 2 - this.HelpImage.getHeight() / 2, null);
        }
    }

    public void drawSpriteBound(Graphics2D g2d) {
        int i;
        g2d.setColor(Color.yellow);
        if (this.player.getBoundingBoxs().size() > 0) {
            for (i = 0; i < this.player.getBoundingBoxs().size(); ++i) {
                g2d.draw(this.player.getBoundingBoxs().get(i));
            }
        } else {
            g2d.draw(this.player.getBoundingBox());
        }
        for (i = 0; i < this.enemySprites.size(); ++i) {
            this.enemySprites.get(i).drawSprite(g2d);
            ArrayList<Rectangle> bound = this.enemySprites.get(i).getBoundingBoxs();
            if (bound.size() > 0) {
                for (int j = 0; j < bound.size(); ++j) {
                    g2d.draw(bound.get(j));
                }
                continue;
            }
            g2d.draw(this.enemySprites.get(i).getBoundingBox());
        }
        for (i = 0; i < this.enemyBullet.size(); ++i) {
            g2d.draw(this.enemyBullet.get(i).getBoundingBox());
        }
        for (i = 0; i < this.playerBullet.size(); ++i) {
            g2d.draw(this.playerBullet.get(i).getBoundingBox());
        }
    }

    public void paint(Graphics g) {
        g.drawImage(this.bufImg, 0, 0, null);
    }

    public static void main(String[] arg) {
        TestSprite ttPanel = new TestSprite();
        ttPanel.start();
        JFrame app = new JFrame("Sprite and Collision");
        app.getContentPane().add((Component)ttPanel, "Center");
        app.setDefaultCloseOperation(3);
        app.addKeyListener(ttPanel);
        app.pack();
        app.setResizable(false);
        app.setVisible(true);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent arg0) {
    }

    public void mouseExited(MouseEvent arg0) {
    }

    public void mousePressed(MouseEvent arg0) {
    }

    public void mouseReleased(MouseEvent arg0) {
    }

    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        switch (keyCode) {
            case 27: {
                this.stop();
                System.exit(0);
                break;
            }
            case 72: {
                this.pause = !this.pause;
                boolean bl = this.showHelp = !this.showHelp;
            }
        }
        if (!this.pause) {
            switch (keyCode) {
                case 66: {
                    boolean bl = this.showBound = !this.showBound;
                }
            }
        }
        if (!this.pause && this.player.getState() != HeliSprite.STATE_EXPLODING) {
            switch (keyCode) {
                case 17: {
                    if (this.fireEnable) break;
                    this.fireEnable = true;
                    this.player.fire();
                    break;
                }
                case 37: {
                    this.player.setStep(-4, 0);
                    break;
                }
                case 39: {
                    this.player.setStep(4, 0);
                    break;
                }
                case 38: {
                    this.player.setStep(0, -4);
                    break;
                }
                case 40: {
                    this.player.setStep(0, 4);
                }
            }
        }
    }

    public void keyReleased(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (!this.pause && this.player.getState() != HeliSprite.STATE_EXPLODING) {
            switch (keyCode) {
                case 17: {
                    this.fireEnable = false;
                    this.player.normal();
                    break;
                }
                case 37: {
                    this.player.setStep(0, 0);
                    break;
                }
                case 39: {
                    this.player.setStep(0, 0);
                    break;
                }
                case 38: {
                    this.player.setStep(0, 0);
                    break;
                }
                case 40: {
                    this.player.setStep(0, 0);
                }
            }
        }
    }

    public void keyTyped(KeyEvent arg0) {
    }

    public void mouseDragged(MouseEvent arg0) {
    }

    public void mouseMoved(MouseEvent arg0) {
    }
}

