/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.LinkedList;

public class NetworkData
implements Protocol {
    NetworkDataListener NDL;
    Socket client;
    boolean koneksi;
    private TerimaData terimadata;
    private KirimData kirimdata;

    NetworkData(String host, int port, NetworkDataListener NDL) {
        try {
            this.NDL = NDL;
            this.client = new Socket(host, port);
            DataInputStream in = new DataInputStream(this.client.getInputStream());
            DataOutputStream out = new DataOutputStream(this.client.getOutputStream());
            this.terimadata = new TerimaData(in);
            this.kirimdata = new KirimData(out);
            this.koneksi = true;
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void disconnect() {
        if (this.koneksi) {
            this.NDL.networkDisconnected("disconnected..");
            this.koneksi = false;
            this.kirimdata.destroy();
            this.terimadata.destroy();
            try {
                this.client.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.client = null;
        }
        System.out.println("Client Disconnected");
    }

    public void kirimData(String data) {
        this.kirimdata.tambahData(data);
    }

    public class KirimData
    implements Runnable {
        Thread loop;
        LinkedList tampungData;
        DataOutputStream out;

        public KirimData(DataOutputStream out) {
            this.out = out;
            this.tampungData = new LinkedList();
            this.loop = new Thread(this);
            this.loop.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void tambahData(String data) {
            LinkedList linkedList = this.tampungData;
            synchronized (linkedList) {
                this.tampungData.add(data);
                this.tampungData.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Thread thisThread = Thread.currentThread();
            while (this.loop == thisThread) {
                LinkedList linkedList = this.tampungData;
                synchronized (linkedList) {
                    if (this.tampungData.isEmpty() && this.loop != null) {
                        try {
                            this.tampungData.wait();
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                }
                while (this.tampungData.size() > 0) {
                    String data;
                    linkedList = this.tampungData;
                    synchronized (linkedList) {
                        data = (String)this.tampungData.removeFirst();
                    }
                    try {
                        this.out.writeUTF(data);
                    }
                    catch (IOException e) {
                        NetworkData.this.disconnect();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            this.loop = null;
            LinkedList linkedList = this.tampungData;
            synchronized (linkedList) {
                this.tampungData.notify();
            }
        }
    }

    public class TerimaData
    implements Runnable {
        Thread loop;
        private DataInputStream in;

        public TerimaData(DataInputStream in) {
            this.in = in;
            this.loop = new Thread(this);
            this.loop.start();
        }

        public void run() {
            Thread thisThread = Thread.currentThread();
            while (this.loop == thisThread) {
                try {
                    String data = this.in.readUTF();
                    NetworkData.this.NDL.menerimaData(data);
                }
                catch (IOException e) {
                    NetworkData.this.disconnect();
                }
            }
        }

        public void destroy() {
            this.loop = null;
        }
    }
}

