/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */



/**
 *
 * @author Riyan
 */

import java.io.*;
import java.net.*;
import java.util.*;

public class ProsesClient implements Protocol{
      Socket client;
      boolean koneksi;
    private TerimaData terimadata;
    private KirimData kirimdata;
    public static ArrayList clientList = new ArrayList();
    String nama;
    
      ProsesClient(Socket client){
            try{
            this.client = client;
            DataInputStream in = new DataInputStream(client.getInputStream());
            DataOutputStream out = new DataOutputStream(client.getOutputStream());
            terimadata = new TerimaData(in);
            kirimdata = new KirimData(out);
            koneksi = true;
            synchronized(clientList){
                 clientList.add(this);
            }
        }
        catch(IOException e){
            System.out.println("Tidak dapat terkoneksi: "+e);
        }
      }
      
    public class TerimaData implements Runnable{
      Thread loop;
        private DataInputStream in;
        public TerimaData(DataInputStream in){
            this.in = in;
            loop = new Thread(this);
            loop.start();
        }
        
        public void run(){
            Thread thisThread = Thread.currentThread();
            while(loop==thisThread){
                 try{
                     String data = in.readUTF();

                 prosesData(data);
            }
            catch(IOException e){
                 disconnect();
            }
        }
    }
        
    public void destroy(){
        loop = null;
    }
}
    
public class KirimData implements Runnable{
  Thread loop;
    LinkedList tampungData;
    DataOutputStream out;
    public KirimData(DataOutputStream out){
        this.out = out;
        tampungData = new LinkedList();
        loop = new Thread(this);
        loop.start();
    }
    
    public void tambahData(String data){
        synchronized(tampungData){
               tampungData.add(data);
               tampungData.notify();
        }
    }
    public void run(){
        String data;
        Thread thisThread = Thread.currentThread();
        while(loop==thisThread){
            synchronized(tampungData){
                 if(tampungData.isEmpty() && loop!=null){
                     try{
                           tampungData.wait();
                     }
                     catch(InterruptedException e) { }
                 }
            }
            
            while(tampungData.size()>0){
                synchronized(tampungData){
                     data = (String)tampungData.removeFirst();
                }
                try{
                     out.writeUTF(data);
                }
                catch(IOException e){
                     disconnect();
                }
            }
        }
    }
    
    public void destroy(){
        loop = null;
        synchronized(tampungData){
              tampungData.notify();
        }
    }
}

public synchronized void disconnect(){
    if(koneksi){
        synchronized(clientList){
            clientList.remove(this);
        }
        broadcast(CHAT_HAPUS_USER+"|"+nama);
        koneksi = false;
        kirimdata.destroy();
        terimadata.destroy();
        try{
            client.close();
        }
        catch(Exception e) {}
        client = null;
    }
    
    System.out.println("Client Disconnected");
}

public static void broadcast(String data){
    synchronized(clientList){
        ProsesClient user;
        for(int i=0; i<clientList.size(); i++){
            user = (ProsesClient)clientList.get(i);
            user.kirimData(data);
        }
    }
}

public void broadcastToClient(String data){
    synchronized(clientList){
        ProsesClient user;
        for(int i=0; i<clientList.size(); i++){
            user = (ProsesClient)clientList.get(i);
            if(user!=this)
                 user.kirimData(data);
        }
    }
}

public void kirimData(String data){
    kirimdata.tambahData(data);
}

public void prosesData(String data){
  StringTokenizer st = new StringTokenizer(data, "|");
    int kode = Integer.parseInt(st.nextToken());
  switch(kode){
        case SET_USER:{
               nama=st.nextToken();
               break;
        }
        case CHAT_USER_BARU :{
               broadcastToClient(data);
               break;
        }
        case CHAT_HAPUS_USER :{
               broadcast(data);
               break;
        }
        case CHAT_PESAN_USER :{
            broadcast(data);
            break;
      }
    }
  }
}
