﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Point_Proses_FaisalRidwan
{
    public partial class Form1 : Form
    {
        Bitmap img, img2;
        int nGreen, nBlue, nRed;
      
        public Form1()
        {
            InitializeComponent();
        }

        private void openToolStripMenuItem_Click(object sender, EventArgs e)
        {
            OpenFileDialog oFile = new OpenFileDialog();
            if (oFile.ShowDialog() == DialogResult.OK)
            {
                img = new Bitmap(new Bitmap(oFile.FileName), pictureBox1.Width, pictureBox1.Height);
                pictureBox1.Image = img;
            }
        }

        private void saveToolStripMenuItem_Click(object sender, EventArgs e)
        {
            SaveFileDialog objek = new SaveFileDialog();
            objek.Filter = "JPEG File (*.jpeg)|*.jpeg|Gif File (*.gif)|*.gif|Bitmap File (*.bmp)|*.bmp";
            objek.Title = "Save an Image File";
            if (objek.ShowDialog() == DialogResult.OK)
            {
                if (objek.FileName != "")
                {
                    System.IO.FileStream fs = (System.IO.FileStream)objek.OpenFile();
                    switch (objek.FilterIndex)
                    {
                        case 1:
                            this.pictureBox2.Image.Save(fs, System.Drawing.Imaging.ImageFormat.Jpeg);
                            break;
                        case 2:
                            this.pictureBox2.Image.Save(fs, System.Drawing.Imaging.ImageFormat.Gif);
                            break;
                        case 3:
                            this.pictureBox2.Image.Save(fs, System.Drawing.Imaging.ImageFormat.Bmp);
                            break;
                    }
                }

            }
        }

        private void exitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Application.Exit();
        }

        private void brightnessToolStripMenuItem_Click(object sender, EventArgs e)
        {
            int i, j;
            if (img != null)
            {
                img2 = new Bitmap(img);
                for (i = 0; i <= img2.Width - 1; i++)
                {
                    for (j = 0; j <= img2.Height - 1; j++)
                    {
                        Color pixelColor = img2.GetPixel(i, j);
                        nRed = pixelColor.R + 100;
                        nGreen = pixelColor.G + 100;
                        nBlue = pixelColor.B + 100;
                        if (nRed > 255)
                            nRed = 255;
                        if (nGreen > 255)
                            nGreen = 255;
                        if (nBlue > 255)
                            nBlue = 255;
                        Color newpixelColor = Color.FromArgb(nRed, nGreen, nBlue);
                        img2.SetPixel(i, j, newpixelColor);
                    }
                }
                pictureBox2.Image = img2;
            }
        }

        private void grayScaleToolStripMenuItem_Click(object sender, EventArgs e)
        {
            int i, j, rata;
            if (img != null)
            {
                img2 = new Bitmap(img);
                for (i = 0; i <= img2.Width - 1; i++)
                {
                    for (j = 0; j <= img2.Height - 1; j++)
                    {
                        Color pixelColor = img2.GetPixel(i, j);
                        nRed = pixelColor.R;
                        nGreen = pixelColor.G;
                        nBlue = pixelColor.B;
                        rata = Convert.ToInt32((nRed + nBlue + nGreen) / 3);
                        Color newpixelColor = Color.FromArgb(rata, rata, rata);
                        img2.SetPixel(i, j, newpixelColor);
                    }
                }
                pictureBox2.Image = img2;
            }
        }

        private void contrastStretchingToolStripMenuItem_Click(object sender, EventArgs e)
        {
            int c1, d1, c2, d2, i, j;
            c1 = 10;
            d1 = 100;
            c2 = 10;
            d2 = 100;
            if (img != null)
            {
                img2 = new Bitmap(img);
                for (i = 0; i <= img2.Width - 1; i++)
                {
                    for (j = 0; j <= img2.Height - 1; j++)
                    {
                        Color pixelColor = img2.GetPixel(i, j);
                        nRed = pixelColor.R;
                        if (nRed < c1)
                            nRed = nRed * d1 / c1;
                        else
                            if (nRed < c2)
                                nRed = d1 + (nRed - c1) * (d2 - d1) / (c2 - c1);
                            else
                                nRed = d2 + (nRed - c2) * (255 - d2) / (255 - c2);

                        nGreen = pixelColor.G;
                        if (nGreen < c1)
                            nGreen = nGreen * d1 / c1;
                        else
                            if (nGreen < c2)
                                nGreen = d1 + (nGreen - c1) * (d2 - d1) / (c2 - c1);
                            else
                                nGreen = d2 + (nGreen - c2) * (255 - d2) / (255 - c2);
                        nBlue = pixelColor.B;
                        if (nBlue < c1)
                            nBlue = nBlue * d1 / c1;
                        else
                            if (nBlue < c2)
                                nBlue = d1 + (nBlue - c1) * (d2 - d1) / (c2 - c1);
                            else
                                nBlue = d2 + (nBlue - c2) * (255 - d2) / (255 - c2);
                        Color newPixelColor = Color.FromArgb(nRed, nGreen, nBlue);
                        img2.SetPixel(i, j, newPixelColor);
                    }
                }
                pictureBox2.Image = img2;
            }
        }

        private void negasiToolStripMenuItem_Click(object sender, EventArgs e)
        {
            int i, j;
            if (img != null)
            {
                img2 = new Bitmap(img);
                for (i = 0; i <= img2.Width - 1; i++)
                {
                    for (j = 0; j <= img2.Height - 1; j++)
                    {
                        Color pixelColor = img2.GetPixel(i, j);
                        nRed = 255 - pixelColor.R;
                        nGreen = 255 - pixelColor.G;
                        nBlue = 255 - pixelColor.B;

                        Color newpixelColor = Color.FromArgb(nRed, nGreen, nBlue);
                        img2.SetPixel(i, j, newpixelColor);
                    }
                }
                pictureBox2.Image = img2;
            }
        }

        private void thresholdToolStripMenuItem_Click(object sender, EventArgs e)
        {
            int i, j;
            if (img != null)
            {
                img2 = new Bitmap(img);
                for (i = 0; i <= img2.Width - 1; i++)
                {
                    for (j = 0; j <= img2.Height - 1; j++)
                    {
                        Color pixelColor = img2.GetPixel(i, j);
                        nRed = pixelColor.R;
                        nGreen = pixelColor.G;
                        nBlue = pixelColor.B;

                        if (nRed < 127)
                            nRed = 0;
                        else nRed = 255;
                        if (nGreen < 127)
                            nGreen = 0;
                        else nGreen = 255;
                        if (nBlue < 127)
                            nBlue = 0;
                        else nBlue = 255;
                        Color newpixelColor = Color.FromArgb(nRed, nGreen, nBlue);
                        img2.SetPixel(i, j, newpixelColor);
                    }
                }
                pictureBox2.Image = img2;
            }
        }

        private void blackWhiteToolStripMenuItem_Click(object sender, EventArgs e)
        {
            int i, j, rata;
            if (img != null)
            {
                img2 = new Bitmap(img);
                for (i = 0; i <= img2.Width - 1; i++)
                {
                    for (j = 0; j <= img2.Height - 1; j++)
                    {
                        Color pixelColor = img2.GetPixel(i, j);
                        nRed = pixelColor.R;
                        nGreen = pixelColor.G;
                        nBlue = pixelColor.B;
                        rata = Convert.ToInt32((nRed + nBlue + nGreen) / 3);
                        if (rata > 127)
                            rata = 255;
                        else
                            rata = 0;
                        Color newpixelColor = Color.FromArgb(rata, rata, rata);
                        img2.SetPixel(i, j, newpixelColor);
                    }
                }
                pictureBox2.Image = img2;
            }
        }

        private void identityToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Form2 f2 = new Form2();
            if (f2.ShowDialog() == DialogResult.OK)
            {
            }
        }
    }
}
