﻿using System;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using System.Windows.Forms;

public partial class _Default : System.Web.UI.Page 
{
    protected void Page_Load(object sender, EventArgs e)
    {
        //mengecek PostBack pada halaman web
        if (this.IsPostBack == false)
        {
            selectMataUang.Items.Add(new ListItem( "Rupiah","12000"));
            selectMataUang.Items.Add(new ListItem( "Euro", "1.3"));
        }
       
        //cek isi value ViewState 
        if (ViewState["selamatdatang"] == null)
        {
            MessageBox.Show("Selamat Datang Di ASP.Net", "Welcome");
        }
        //membuat ViewState selamat datang
        ViewState["selamatdatang"] = "OK";
        //mengganti text pada label1
        Label1.Text = "Websiteku :" + System.Environment.NewLine + ConfigurationManager.AppSettings["suryodesign website"] + "<br> Blogku : " + ConfigurationManager.AppSettings["suryodesign blog"];
    }

    protected void convertMataUang(Object sender, EventArgs e)
    {
        //try kita gunakan untuk meletakkan code dan 
        //menghandlenya ke dalam catch bila ada kesalahan
        try
        {
            //mengambil nilai dari list item berdasarkan indexnya
            ListItem item = selectMataUang.Items[selectMataUang.SelectedIndex];
            //input tidak boleh kosong
            if (txtDollar.Text == "")
            {
                MessageBox.Show("Uang tidak boleh kosong");
                //break code
                return;
            }
            //convert nilai dari item menjadi decimal
            decimal konversi = decimal.Parse(item.Value);
            //convert nilai dari hasil kali textbox inputan dengan nilai konversi
            decimal rupiah = decimal.Parse(txtDollar.Text) * konversi;
            //inner text kita gunakan untuk memunculkan text di dalam DIV pada HTML
            tampilkanDisini.InnerText = "Jumlahnya dalam rupiah adalah : " + rupiah.ToString();      
        }
        //menangkap kesalahan
        catch (Exception)
        {
            MessageBox.Show("Tidak boleh mengandung huruf");
            //break code
            return;
        }
    } 
}
