/**
 * Program      : Controls.java
 * Date         : May 7, 2001
 *
 * Author       : Taufik Fuadi Abidin
 */

import java.awt.event.*;
import java.awt.*;

public class Controls extends Panel
                      implements ItemListener, ActionListener
{
  private SortItem item;
  private Label result, time;

  public Controls(SortItem item)
  {
    this.item = item;
    setLayout(new BorderLayout());
    setBackground(Color.gray);
    setFont(new Font("Helvetica", Font.PLAIN, 14));

    Panel up = new Panel();
    up.setLayout(new FlowLayout());
    Panel bottom = new Panel();
    bottom.setLayout(new FlowLayout());

    result = new Label("Hallo");
    result.setForeground(Color.white);

    Label delay = new Label("Delay:");
    delay.setForeground(Color.white);

    Choice delayDuration = new Choice();
    delayDuration.addItem("10");
    delayDuration.addItem("50");
    delayDuration.addItem("100");
    delayDuration.addItem("200");
    delayDuration.addItem("250");
    Button buttonStart = new Button("Start");
    Button buttonRand = new Button("Rand");
    buttonStart.addActionListener(this);
    buttonRand.addActionListener(this);
    delayDuration.addItemListener(this);
    bottom.add(delay);
    bottom.add(delayDuration);
    bottom.add(buttonStart);
    bottom.add(buttonRand);
    add("Center", result);
    add("South", bottom);
  }

  public void setResultText(String str)
  {
    result.setText(str);
    repaint();
  }

  public void actionPerformed(ActionEvent e)
  {
	if (e.getSource() instanceof Button)
	{
	  String buttonLabel = (String) e.getActionCommand();
	  if (buttonLabel.equals("Start"))
      {
        item.startSort();
      }
	  else if (buttonLabel.equals("Rand"))
      {
        item.startRand();
      }
    }
  }

  public void itemStateChanged(ItemEvent e)
  {
    if (e.getSource() instanceof Choice)
    {
      String choice = (String) e.getItem();
      if (choice.equals("250"))
      {
        item.setDelay(250);
      }
      else if (choice.equals("200"))
	  {
	    item.setDelay(200);
      }
      else if (choice.equals("100"))
      {
        item.setDelay(100);
      }
      else if (choice.equals("50"))
      {
        item.setDelay(50);
      }
      else if (choice.equals("10"))
      {
        item.setDelay(10);
      }
    }
  }
}
