/**
 * Program       : SortItem.java
 * Date          : May 7, 2001
 *
 * Author        : Taufik Fuadi Abidin
 *
 * Acknowledgment: Original source written by
 *                 James Gosling from Sun Microsystems, Inc.
 *                 1997
 */

import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.util.*;

public class SortItem extends Applet implements Runnable
{
  private Thread kicker;
  private int width, height;
  private Controls controls;
  private int arr[];
  private String algName;
  private SortAlgorithm algorithm;
  private int h1 = -1;
  private int h2 = -1;
  public static int jeda = 10;

  private void scramble()
  {
    int item[] = new int[25];
    double f = width / (double) item.length;

    for (int i = item.length; --i >= 0;)
    {
      item[i] = (int)(i * f) + 10;
    }

    int seed = item.length-1;
    for (int i = item.length; --i >= 0;)
    {
      int j = (int)(seed * Math.random());
      int temp = item[i];
      item[i] = item[j];
      item[j] = temp;
    }
    arr = item;
  }

  public void pause(int H1, int H2)
  {
    h1 = H1;
    h2 = H2;
    if (kicker != null)
    {
      repaint();
    }
    try
    {
      Thread.sleep(SortItem.jeda);
    }
    catch (InterruptedException e)
    {
    }
  }

  public void init()
  {
    String alg = getParameter("alg");
    if (alg == null)
    {
      alg = "BubbleSort";
    }
    algName  = alg + "Algorithm";
    height   = 300;
    width    = 300;
    controls = new Controls(this);

    setBackground(Color.white);
    setLayout(new BorderLayout());
    add("South",controls);
  }

  public void start()
  {
    scramble();
    controls.setResultText("");
    repaint();
  }

 /**
  * Paint the array of numbers as a list
  * of horizontal lines of varying lengths.
  */
  public void paint(Graphics g)
  {
    int item[] = arr;
    int nbar = 25;
    int wbar = (int)(width / nbar);
    int dx = width - wbar;

    // Erase old bar
    g.setColor(getBackground());
    for (int i = item.length; --i >= 0; dx -= wbar)
    {
      g.fillRect(dx, 0, wbar, height-arr[i]);
    }

    // Draw new bar
    dx = width - wbar;
    g.setColor(Color.darkGray);
    for (int i = item.length; --i >= 0; dx -= wbar)
    {
      g.fillRect(dx, height-arr[i], wbar, arr[i]);
    }

    if (h1 >= 0)
    {
      g.setColor(Color.red);
      dx = h1 * wbar;
      g.drawLine(dx, 0, dx, height-1);
    }
    if (h2 >= 0)
    {
      g.setColor(Color.blue);
      dx = h2 * wbar;
      g.drawLine(dx, 0, dx, height-1);
    }
  }

  public void update(Graphics g)
  {
    paint(g);
  }

 /**
  * Run the algorithm, called by class Thread once the sorting
  * algorithm started.
  */
  public void run()
  {
    try
    {
      if (algorithm == null)
      {
	    algorithm= (SortAlgorithm)Class.forName(algName).newInstance();
	    algorithm.setParent(this);
      }
      algorithm.init();
      algorithm.sort(arr);
      controls.setResultText("       Pertukaran: "+
                             String.valueOf(algorithm.getNumOfSwap())+
                             "      Perbandingan: "+String.valueOf(algorithm.getNumOfCompare()));
    }
    catch(Exception e)
    {
    }
  }

 /**
  * Stop the applet. Kill any algorithm that is still sorting.
  */
  public synchronized void stop()
  {
    if (algorithm != null)
    {
      try
      {
        algorithm.stop();
      }
      catch (IllegalThreadStateException e)
      {
      }
      kicker = null;
    }
  }

  public synchronized void startSort()
  {
    if (kicker == null || !kicker.isAlive())
    {
      kicker = new Thread(this);
      kicker.start();
    }
  }

  public synchronized void startRand()
  {
    if (kicker == null || !kicker.isAlive())
    {
      //kicker = new Thread(this);
      start();
    }
  }

  public String getAppletInfo()
  {
    return "Visualisasi Metode Pengurutan Dasar (c) 2001";
  }

  public String[][] getParameterInfo()
  {
    String[][] info =
    {
      {"alg", "string", "The name of the algorithm to run. Example:  Use 'InsertionSort' to run the InsertionSortAlgorithm class."}
    };
    return info;
  }

  public void setDelay(int jeda)
  {
    SortItem.jeda = jeda;
  }
}
