{-----------------------------------------------------------------------------
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in compliance
with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/MPL-1.1.html

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either expressed or implied. See the License for
the specific language governing rights and limitations under the License.

The Original Code is: DialogIndonesia.pas, released on 2007-10-18

The Initial Developer of the Original Code is Bayu Prasetio
Portions created by Bayu Prasetio are Copyright (C) 2007 Bayu Prasetio.
All Rights Reserved.
-----------------------------------------------------------------------------}

unit DialogIndonesia;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ComCtrls, CheckLst;

type
  TfrmDialogIndonesia = class(TForm)
    StatusBar1: TStatusBar;
    rgJenisDialog: TRadioGroup;
    gbPilihanTombol: TGroupBox;
    chklbPilihanTombol: TCheckListBox;
    GroupBox2: TGroupBox;
    mmoPesan: TMemo;
    bvTombol: TBevel;
    btnTampil: TButton;
    btnKeluar: TButton;
    procedure btnTampilClick(Sender: TObject);
    procedure btnKeluarClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmDialogIndonesia: TfrmDialogIndonesia;

implementation

{$R *.dfm}

uses
  Consts;

procedure TfrmDialogIndonesia.btnKeluarClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmDialogIndonesia.btnTampilClick(Sender: TObject);
var
  JenisDialog   : TMsgDlgType;
  PilihanTombol : set of TMsgDlgBtn;
  I             : Integer;
begin
  JenisDialog := TMsgDlgType(rgJenisDialog.ItemIndex);
  PilihanTombol := [];
  for I := 0 to chklbPilihanTombol.Count - 1 do
    if chklbPilihanTombol.Checked[I] then Include(PilihanTombol, TMsgDlgBtn(I));
  MessageDlg(mmoPesan.Text, JenisDialog, PilihanTombol, 0);
end;

//------------------------------------------------------------------------------

const
  _NewSMsgDlgWarning = 'Peringatan';
  _NewSMsgDlgError = 'Kesalahan';
  _NewSMsgDlgInformation = 'Informasi';
  _NewSMsgDlgConfirm = 'Konfirmasi';
  _NewSMsgDlgYes = '&Ya';
  _NewSMsgDlgNo = '&Tidak';
  _NewSMsgDlgOK = 'OK';
  _NewSMsgDlgCancel = 'Batal';
  _NewSMsgDlgHelp = '&Panduan';
  _NewSMsgDlgHelpNone = 'Panduan tidak tersedia';
  _NewSMsgDlgHelpHelp = 'Panduan';
  _NewSMsgDlgAbort = '&Batal';
  _NewSMsgDlgRetry = '&Ulang';
  _NewSMsgDlgIgnore = 'A&cuh';
  _NewSMsgDlgAll = '&Semua';
  _NewSMsgDlgNoToAll = 'T&idak untuk Semua';
  _NewSMsgDlgYesToAll = 'Ya untuk S&emua';


{-- taken from bpCodeReplacement.pas by Bayu Prasetio}
procedure ReplaceResourceString(RStringRec: PResStringRec; AString: PChar);
var
  OldProtect: Cardinal;
begin
  if RStringRec = nil then Exit;
  if VirtualProtect(RStringRec, SizeOf(RStringRec^), PAGE_EXECUTE_READWRITE, OldProtect) then
  begin
    RStringRec^.Identifier := Integer(AString);
    VirtualProtect(RStringRec, SizeOf(RStringRec^), OldProtect, @OldProtect);
  end;
end;

initialization
  ReplaceResourceString(@SMsgDlgWarning, _NewSMsgDlgWarning);
  ReplaceResourceString(@SMsgDlgError, _NewSMsgDlgError);
  ReplaceResourceString(@SMsgDlgInformation, _NewSMsgDlgInformation);
  ReplaceResourceString(@SMsgDlgConfirm, _NewSMsgDlgConfirm);
  ReplaceResourceString(@SMsgDlgYes, _NewSMsgDlgYes);
  ReplaceResourceString(@SMsgDlgNo, _NewSMsgDlgNo);
  ReplaceResourceString(@SMsgDlgOK, _NewSMsgDlgOK);
  ReplaceResourceString(@SMsgDlgCancel, _NewSMsgDlgCancel);
  ReplaceResourceString(@SMsgDlgHelp, _NewSMsgDlgHelp);
  ReplaceResourceString(@SMsgDlgHelpNone, _NewSMsgDlgHelpNone);
  ReplaceResourceString(@SMsgDlgHelpHelp, _NewSMsgDlgHelpHelp);
  ReplaceResourceString(@SMsgDlgAbort, _NewSMsgDlgAbort);
  ReplaceResourceString(@SMsgDlgRetry, _NewSMsgDlgRetry);
  ReplaceResourceString(@SMsgDlgIgnore, _NewSMsgDlgIgnore);
  ReplaceResourceString(@SMsgDlgAll, _NewSMsgDlgAll);
  ReplaceResourceString(@SMsgDlgNoToAll, _NewSMsgDlgNoToAll);
  ReplaceResourceString(@SMsgDlgYesToAll, _NewSMsgDlgYesToAll);

end.
